/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.layer;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.MathHelper;
import noppes.npcs.ModelPartConfig;
import noppes.npcs.ModelPartData;
import noppes.npcs.client.layer.LayerInterface;
import noppes.npcs.client.layer.LayerPreRender;
import noppes.npcs.client.model.part.legs.ModelDigitigradeLegs;
import noppes.npcs.client.model.part.legs.ModelHorseLegs;
import noppes.npcs.client.model.part.legs.ModelMermaidLegs;
import noppes.npcs.client.model.part.legs.ModelNagaLegs;
import noppes.npcs.client.model.part.legs.ModelSpiderLegs;
import noppes.npcs.client.model.part.tails.ModelCanineTail;
import noppes.npcs.client.model.part.tails.ModelDragonTail;
import noppes.npcs.client.model.part.tails.ModelFeatherTail;
import noppes.npcs.client.model.part.tails.ModelRodentTail;
import noppes.npcs.client.model.part.tails.ModelSquirrelTail;
import noppes.npcs.client.model.part.tails.ModelTailFin;
import noppes.npcs.constants.EnumParts;
import noppes.npcs.entity.EntityCustomNpc;

public class LayerLegs<T extends EntityLivingBase>
extends LayerInterface<T>
implements LayerPreRender {
    private ModelDigitigradeLegs digitigrade;
    private ModelRenderer dragon;
    private ModelRenderer feathers;
    private ModelRenderer fin;
    private ModelCanineTail fox;
    private ModelRenderer horse;
    private ModelHorseLegs horseLegs;
    private ModelMermaidLegs mermaid;
    private ModelNagaLegs naga;
    private ModelRenderer rodent;
    float rotationPointY;
    float rotationPointZ;
    private ModelSpiderLegs spiderLegs;
    private ModelRenderer squirrel;
    private ModelRenderer tail;

    public LayerLegs(RenderLiving<?> render) {
        super(render);
        this.createParts();
    }

    private void createParts() {
        this.spiderLegs = new ModelSpiderLegs(this.model);
        this.horseLegs = new ModelHorseLegs(this.model);
        this.naga = new ModelNagaLegs((ModelBase)this.model);
        this.mermaid = new ModelMermaidLegs((ModelBase)this.model);
        this.digitigrade = new ModelDigitigradeLegs(this.model);
        this.fox = new ModelCanineTail(this.model);
        this.tail = new ModelRenderer((ModelBase)this.model, 56, 21);
        this.tail.func_78789_a(-1.0f, 0.0f, 0.0f, 2, 9, 2);
        this.tail.func_78793_a(0.0f, 0.0f, 1.0f);
        this.setRotation(this.tail, 0.8714253f, 0.0f, 0.0f);
        this.horse = new ModelRenderer((ModelBase)this.model);
        this.horse.func_78787_b(32, 32);
        this.horse.func_78793_a(0.0f, -1.0f, 1.0f);
        ModelRenderer tailBase = new ModelRenderer((ModelBase)this.model, 0, 26);
        tailBase.func_78787_b(32, 32);
        tailBase.func_78789_a(-1.0f, -1.0f, 0.0f, 2, 2, 3);
        this.setRotation(tailBase, -1.134464f, 0.0f, 0.0f);
        this.horse.func_78792_a(tailBase);
        ModelRenderer tailMiddle = new ModelRenderer((ModelBase)this.model, 0, 13);
        tailMiddle.func_78787_b(32, 32);
        tailMiddle.func_78789_a(-1.5f, -2.0f, 3.0f, 3, 4, 7);
        this.setRotation(tailMiddle, -1.134464f, 0.0f, 0.0f);
        this.horse.func_78792_a(tailMiddle);
        ModelRenderer tailTip = new ModelRenderer((ModelBase)this.model, 0, 0);
        tailTip.func_78787_b(32, 32);
        tailTip.func_78789_a(-1.5f, -4.5f, 9.0f, 3, 4, 7);
        this.setRotation(tailTip, -1.40215f, 0.0f, 0.0f);
        this.horse.func_78792_a(tailTip);
        this.horse.field_78795_f = 0.5f;
        this.dragon = new ModelDragonTail(this.model);
        this.squirrel = new ModelSquirrelTail(this.model);
        this.fin = new ModelTailFin(this.model);
        this.rodent = new ModelRodentTail(this.model);
        this.feathers = new ModelFeatherTail(this.model);
    }

    @Override
    public void preRender(EntityCustomNpc player) {
        boolean b;
        this.npc = player;
        this.playerdata = player.modelData;
        ModelPartData data = this.playerdata.getPartData(EnumParts.LEGS);
        ModelRenderer bipedLeftLeg = this.model.field_178722_k;
        ModelRenderer bipedRightLeg = this.model.field_178721_j;
        bipedRightLeg.field_78807_k = b = data == null || data.type != 0;
        bipedLeftLeg.field_78807_k = b;
    }

    @Override
    public void render(float par2, float par3, float par4, float par5, float par6, float par7) {
        this.renderLegs(par7);
        if (!this.npc.animation.showParts.get((Object)EnumParts.BODY).booleanValue()) {
            return;
        }
        this.renderTails(par7);
    }

    private void renderLegs(float par7) {
        ModelPartData data = this.playerdata.getPartData(EnumParts.LEGS);
        if (data.type <= 0) {
            return;
        }
        GlStateManager.func_179094_E();
        ModelPartConfig config = this.playerdata.getPartConfig(EnumParts.LEG_LEFT);
        this.preRender(data);
        if (data.type == 1) {
            GlStateManager.func_179109_b((float)0.0f, (float)(config.offset[1] * 2.0f), (float)(config.offset[2] * par7 + 0.04f));
            GlStateManager.func_179152_a((float)config.scale[0], (float)config.scale[1], (float)config.scale[2]);
            this.naga.func_78785_a(par7);
        } else if (data.type == 2) {
            GlStateManager.func_179137_b((double)0.0, (double)((double)(config.offset[1] * 1.76f) - 0.1 * (double)config.scale[1]), (double)(config.offset[2] * par7));
            GlStateManager.func_179152_a((float)1.06f, (float)1.06f, (float)1.06f);
            GlStateManager.func_179152_a((float)config.scale[0], (float)config.scale[1], (float)config.scale[2]);
            this.spiderLegs.func_78785_a(par7);
        } else if (data.type == 3) {
            if (config.scale[1] >= 1.0f) {
                GlStateManager.func_179109_b((float)0.0f, (float)(config.offset[1] * 1.76f), (float)(config.offset[2] * par7));
            } else {
                GlStateManager.func_179109_b((float)0.0f, (float)(config.offset[1] * 1.86f), (float)(config.offset[2] * par7));
            }
            GlStateManager.func_179152_a((float)0.79f, (float)(0.9f - config.scale[1] / 10.0f), (float)0.79f);
            GlStateManager.func_179152_a((float)config.scale[0], (float)config.scale[1], (float)config.scale[2]);
            this.horseLegs.func_78785_a(par7);
        } else if (data.type == 4) {
            GlStateManager.func_179109_b((float)0.0f, (float)(config.offset[1] * 1.86f), (float)(config.offset[2] * par7));
            GlStateManager.func_179152_a((float)config.scale[0], (float)config.scale[1], (float)config.scale[2]);
            this.mermaid.func_78785_a(par7);
        } else if (data.type == 5) {
            GlStateManager.func_179109_b((float)0.0f, (float)(config.offset[1] * 1.86f), (float)(config.offset[2] * par7));
            GlStateManager.func_179152_a((float)config.scale[0], (float)config.scale[1], (float)config.scale[2]);
            this.digitigrade.func_78785_a(par7);
        }
        GlStateManager.func_179121_F();
    }

    private void renderTails(float par7) {
        ModelPartData data = this.playerdata.getPartData(EnumParts.TAIL);
        if (data == null) {
            return;
        }
        GlStateManager.func_179094_E();
        ModelPartConfig config = this.playerdata.getPartConfig(EnumParts.LEG_LEFT);
        GlStateManager.func_179109_b((float)(config.offset[0] * par7), (float)(config.offset[1] + this.rotationPointY * par7), (float)(config.offset[2] * par7 + this.rotationPointZ * par7));
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)((config.scale[2] - 1.0f) * 5.0f * par7));
        GlStateManager.func_179152_a((float)config.scale[0], (float)config.scale[1], (float)config.scale[2]);
        this.preRender(data);
        if (data.type == 0) {
            if (data.pattern == 1) {
                this.tail.field_78800_c = -0.5f;
                this.tail.field_78796_g -= 0.2f;
                this.tail.func_78785_a(par7);
                this.tail.field_78800_c += 1.0f;
                this.tail.field_78796_g += 0.4f;
                this.tail.func_78785_a(par7);
                this.tail.field_78800_c = 0.0f;
            } else {
                this.tail.func_78785_a(par7);
            }
        } else if (data.type == 1) {
            this.dragon.func_78785_a(par7);
        } else if (data.type == 2) {
            this.horse.func_78785_a(par7);
        } else if (data.type == 3) {
            this.squirrel.func_78785_a(par7);
        } else if (data.type == 4) {
            this.fin.func_78785_a(par7);
        } else if (data.type == 5) {
            this.rodent.func_78785_a(par7);
        } else if (data.type == 6) {
            this.feathers.func_78785_a(par7);
        } else if (data.type == 7) {
            this.fox.func_78785_a(par7);
        }
        GlStateManager.func_179121_F();
    }

    @Override
    public void rotate(float par1, float par2, float par3, float par4, float par5, float par6) {
        this.rotateLegs(par1, par2, par3, par4, par5, par6);
        this.rotateTail(par1, par2, par3, par4, par5, par6);
    }

    public void rotateLegs(float par1, float par2, float par3, float par4, float par5, float par6) {
        ModelPartData part = this.playerdata.getPartData(EnumParts.LEGS);
        if (part.type == 2) {
            this.spiderLegs.setRotationAngles(this.playerdata, par1, par2, par3, par4, par5, par6, (Entity)this.npc);
        } else if (part.type == 3) {
            this.horseLegs.setRotationAngles(this.playerdata, par1, par2, par3, par4, par5, par6, (Entity)this.npc);
        } else if (part.type == 1) {
            this.naga.isRiding = this.model.field_78093_q;
            this.naga.isSleeping = this.npc.func_70608_bn();
            this.naga.isCrawling = this.npc.currentAnimation == 7;
            this.naga.isSneaking = this.model.field_78117_n;
            this.naga.setRotationAngles(par1, par2, par3, par4, par5, par6, (Entity)this.npc);
        } else if (part.type == 4) {
            this.mermaid.setRotationAngles(par1, par2, par3, par4, par5, par6, (Entity)this.npc);
        } else if (part.type == 5) {
            this.digitigrade.setRotationAngles(par1, par2, par3, par4, par5, par6, (Entity)this.npc);
        }
    }

    public void rotateTail(float par1, float par2, float par3, float par4, float par5, float par6) {
        ModelPartData part = this.playerdata.getPartData(EnumParts.LEGS);
        ModelPartData partTail = this.playerdata.getPartData(EnumParts.TAIL);
        ModelPartConfig config = this.playerdata.getPartConfig(EnumParts.LEG_LEFT);
        float rotateAngleY = MathHelper.func_76134_b((float)(par1 * 0.6662f)) * 0.2f * par2;
        float rotateAngleX = MathHelper.func_76126_a((float)(par3 * 0.067f)) * 0.05f;
        this.rotationPointY = 11.0f;
        if (part.type == 2) {
            this.rotationPointY = 12.0f + (config.scale[1] - 1.0f) * 3.0f;
            this.rotationPointZ = 15.0f + (config.scale[2] - 1.0f) * 10.0f;
            if (this.npc.func_70608_bn() || this.npc.currentAnimation == 7) {
                this.rotationPointY = 12.0f + 16.0f * config.scale[2];
                this.rotationPointZ = config.scale[1];
                rotateAngleX = -0.7853982f;
            }
        } else if (part.type == 3) {
            this.rotationPointY = 10.0f;
            this.rotationPointZ = 16.0f + (config.scale[2] - 1.0f) * 12.0f;
        } else {
            this.rotationPointZ = 1.0f - config.scale[2];
        }
        if (partTail != null) {
            if (partTail.type == 2) {
                rotateAngleX += 0.5f;
            }
            if (partTail.type == 0) {
                rotateAngleX += 0.87f;
            }
            if (partTail.type == 7) {
                this.fox.setRotationAngles(par1, par2, par3, par4, par5, par6, (Entity)this.npc);
            }
        }
        this.rotationPointZ += this.model.field_178721_j.field_78798_e + 0.5f;
        this.rodent.field_78795_f = rotateAngleX;
        this.fin.field_78795_f = rotateAngleX;
        this.horse.field_78795_f = rotateAngleX;
        this.squirrel.field_78795_f = rotateAngleX;
        this.dragon.field_78795_f = rotateAngleX;
        this.feathers.field_78795_f = rotateAngleX;
        this.tail.field_78795_f = rotateAngleX;
        this.fox.field_78795_f = rotateAngleX;
        this.rodent.field_78796_g = rotateAngleY;
        this.fin.field_78796_g = rotateAngleY;
        this.horse.field_78796_g = rotateAngleY;
        this.squirrel.field_78796_g = rotateAngleY;
        this.dragon.field_78796_g = rotateAngleY;
        this.feathers.field_78796_g = rotateAngleY;
        this.tail.field_78796_g = rotateAngleY;
        this.fox.field_78796_g = rotateAngleY;
    }

    @Override
    public boolean func_177142_b() {
        return true;
    }
}

